<?php
/**
 * Project: MinervaKB.
 * Copyright: 2015-2017 @KonstruktStudio
 */
class MKB_WooCommerce {

    private $account_support_url = 'support';

    public function __construct() {
        $this->add_support_section();

        add_filter( 'woocommerce_product_tabs', array($this, 'woo_kb_product_tab'));
    }

    private function add_support_section() {
        if (!MKB_Options::option('woo_add_support_account_tab')) {
            return;
        }

        if (MKB_Options::option('woo_account_section_url')) {
            $this->account_support_url = MKB_Options::option('woo_account_section_url');
        }

        add_action('init', array($this, 'add_support_endpoint'));
        add_filter('query_vars', array($this, 'support_query_vars'), 0);
        add_filter('woocommerce_account_menu_items', array($this, 'add_support_link_to_account'));
        add_filter('the_title', array($this, 'support_endpoint_title'));
        add_action('woocommerce_account_' . $this->account_support_url . '_endpoint', array($this, 'support_content'));
    }

    /**
     * Support endpoint rewrite
     */
    public function add_support_endpoint() {
        add_rewrite_endpoint($this->account_support_url, EP_ROOT | EP_PAGES);
    }

    /**
     * Parse query var
     * @param $vars
     * @return array
     */
    public function support_query_vars( $vars ) {
        $vars[] = $this->account_support_url;
        return $vars;
    }

    /**
     * Account items
     * @param $items
     * @return array
     */
    public function add_support_link_to_account($items) {
        $total_items = count($items);
        $insert_at = $total_items - 1;

        $items = array_slice($items, 0, $insert_at, true) +
            array($this->account_support_url => MKB_Options::option('woo_account_section_title')) +
            array_slice($items, $insert_at, $total_items - 1, true) ;

        return $items;
    }

    /**
     * Account item title
     * @param $title
     * @return string
     */
    public function support_endpoint_title($title) {
        global $wp_query;

        $is_support_endpoint = isset($wp_query->query_vars[$this->account_support_url]);

        if ($is_support_endpoint && !is_admin() && is_main_query() && in_the_loop() && function_exists('is_account_page') && is_account_page()) {
            $title = MKB_Options::option('woo_account_section_title');
            remove_filter( 'the_title', array($this, 'support_endpoint_title'));
        }

        return $title;
    }

    /**
     * Account item title
     */
    public function support_content() {
        echo do_shortcode(MKB_Options::option('woo_account_section_content'));
    }

    public function woo_kb_product_tab( $tabs ) {
        $product_id = get_the_ID();
        $kb_connect_mode = get_post_meta($product_id, '_mkb_woo_product_kb_connect_mode', true);

        $has_kb_content = in_array($kb_connect_mode, array('articles', 'topic', 'tag'));

        if (MKB_Options::option('woo_add_product_kb_tab') && $has_kb_content) {
            $tabs['mkb_kb_tab'] = array(
                'title'     => MKB_Options::option('woo_product_tab_label'),
                'priority'  => 50,
                'callback'  => array($this, 'woo_kb_product_tab_content')
            );
        }

        return $tabs;
    }

    /**
     * Renders the KB tab in Woo Product Tabs
     */
    public function woo_kb_product_tab_content() {
        if (MKB_Options::option('woo_product_tab_heading')):
            ?><h2><?php echo esc_html(MKB_Options::option('woo_product_tab_heading')); ?></h2><?php
        endif;

        $product_id = get_the_ID();
        $kb_connect_mode = get_post_meta($product_id, '_mkb_woo_product_kb_connect_mode', true);

        if (MKB_Options::option('woo_product_tab_subheading')):
            ?><p><?php echo esc_html(MKB_Options::option('woo_product_tab_subheading')); ?></p><?php
        endif;

        if (MKB_Options::option('woo_product_tab_articles_new_tab')) {
            global $mkb_topic_render_links_in_new_tab;
            $mkb_topic_render_links_in_new_tab = true;
        }

        switch ($kb_connect_mode) {
            case 'articles':
                $kb_articles = get_post_meta($product_id, '_mkb_woo_product_article_ids', true);

                if ($kb_articles) {
                    $kb_articles = explode(',', $kb_articles);
                }

                if (!empty($kb_articles) && is_array($kb_articles)):
                    if (MKB_Options::option('woo_product_tab_articles_new_tab')) {
                        global $mkb_topic_render_links_in_new_tab;
                        $mkb_topic_render_links_in_new_tab = true;
                    }

                    foreach($kb_articles as $article_id):
                        global $post;

                        $post = get_post((int)$article_id);
                        include( MINERVA_KB_PLUGIN_DIR . 'lib/templates/content.php' );
                    endforeach;
                endif;

                wp_reset_postdata();
                break;

            case 'topic':
                $kb_topic = get_post_meta($product_id, '_mkb_woo_product_topic_id', true);

                if ($kb_topic) {
                    MKB_TemplateHelper::render_topic(
                        wp_parse_args(array('id' => (int)$kb_topic), array(
                            'columns' => '2col',
                            'view' => 'list',
                            'limit' => -1,
                        ))
                    );
                }
                break;

            case 'tag':
                $kb_tag = get_post_meta($product_id, '_mkb_woo_product_tag_id', true);

                if ($kb_tag) {
                    MKB_TemplateHelper::render_topic(
                        wp_parse_args(array('id' => (int)$kb_tag), array(
                            'columns' => '2col',
                            'view' => 'list',
                            'limit' => -1,
                            'is_tag' => true
                        ))
                    );
                }
                break;

            default:
                break;
        }
    }
}
